<?php

namespace App\Core\EventListener;

use App\Core\Exception\ApiException;
use http\Exception;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Event\ExceptionEvent;
use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException;
use Symfony\Component\Messenger\Exception\HandlerFailedException;
use Symfony\Component\Serializer\SerializerInterface;

class ExceptionListener
{

    /**
     * ExceptionListener constructor.
     */
    public function __construct(
        private SerializerInterface $serializer
    )
    {
    }

    public function onKernelException(ExceptionEvent $event): void
    {
        $exception = $event->getThrowable();
        if ($exception instanceof ApiException || $exception instanceof HandlerFailedException || $exception instanceof AccessDeniedHttpException || $exception instanceof \InvalidArgumentException) {

            $statusCode = $this->statusCode($exception->getCode());

            if ($exception instanceof ApiException && $statusCode == Response::HTTP_NOT_ACCEPTABLE) {
                $response = JsonResponse::fromJsonString($this->serializer->serialize($exception->getErrors(), 'json'), $statusCode);
            } else {
                $response = new JsonResponse(
                    ['message' => $exception->getMessage()],
                    $statusCode
                );
            }
            $event->setResponse($response);
        }
    }

    private function statusCode(int $statusCode): int
    {
        return ($statusCode < Response::HTTP_CONTINUE || $statusCode >= Response::HTTP_NETWORK_AUTHENTICATION_REQUIRED) ? Response::HTTP_BAD_REQUEST : $statusCode;
    }
}