<?php

namespace App\Controller\Users\Create;

use App\Core\Exception\ApiException;
use App\Entity\Permissions\Permission;
use App\Models\Users\UserModel;
use App\Services\Users\CreateUser;
use OpenApi\Annotations as OA;
use Nelmio\ApiDocBundle\Annotation\Model;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;

/** @OA\Tag(name="Users") */
#[Route('/api/users', name: 'users_')]
class CreateUserController extends AbstractController
{
    public function __construct(
        private CreateUser $createUser
    ) {}

    /**
     * @OA\Post(summary="Create new user account")
     * @OA\RequestBody(
     *     @Model(type=UserModel::class, groups=UserModel::REGISTRATION)
     * )
     * @throws ApiException
     */
    #[IsGranted(Permission::PUBLIC_ACCESS)]
    #[Route('', name: 'create', methods: ['POST'])]
    #[ParamConverter('userModel', options: ["groups" => [...UserModel::REGISTRATION]], converter: "json_deserialize_param_converter")]
    public function create(UserModel $userModel): JsonResponse
    {
        $this->createUser->create($userModel);
        return $this->json(['Email send']);
    }
}