<?php

namespace App\Controller\Units\Update;

use App\Entity\Permissions\Permission;
use App\Entity\Units\Unit;
use App\Models\Gallery\GalleryPhotosModel;
use App\Services\Galleries\UploadPhotos;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;
use OpenApi\Annotations as OA;

/**
 * @OA\Tag(name="Units")
 */
#[Route(path: '/api/units', name: 'units_')]
class UploadPhotoToUnitGalleryController extends AbstractController
{
    public function __construct(
        private UploadPhotos $uploadPhotos
    ) {}

    /**
     * @OA\Post(summary="Upload photo to gallery")
     * @OA\RequestBody(
     *     @OA\MediaType(
     *         mediaType="multipart/form-data",
     *         @OA\Schema(
     *             type="object",
     *             @OA\Property(
     *                 property="photos[]",
     *                 type="array",
     *                 @OA\Items(type="file")
     *             )
     *         )
     *     )
     * )
     */
    #[Security("is_granted('ROLE_UNIT_ADMINISTRATION') or is_granted('ROLE_UNIT_REDACTION')")]
    #[Route(path: '/{unitId}/gallery', name: 'upload_gallery', methods: ['POST'])]
    #[ParamConverter('unit', options: ['mapping' => ['unitId' => 'uuid']])]
    public function upload(Unit $unit, GalleryPhotosModel $galleryModel): JsonResponse
    {
        $this->uploadPhotos->upload($unit, $galleryModel);
        return $this->json('Photos have been uploaded');
    }
}