<?php

namespace App\Controller\Units\Update;

use App\Entity\Permissions\Permission;
use App\Entity\Units\Unit;
use App\Models\Units\UpdateCardInfoModel;
use App\Services\Units\UpdateCardInfo;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;
use OpenApi\Annotations as OA;
use Nelmio\ApiDocBundle\Annotation\Model;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;

/**
 * @OA\Tag(name="Units")
 */
#[Route(path: '/api/units', name: 'units_')]
class UpdateUnitCardInfoController extends AbstractController
{
    public function __construct(
        private UpdateCardInfo $updateCardInfo,
    ) {}

    /**
     * @OA\Put(summary="Update card info")
     * @OA\RequestBody(
     *     @Model(type=UpdateCardInfoModel::class)
     * )
     */

    #[Security("is_granted('ROLE_UNIT_ADMINISTRATION') or is_granted('ROLE_UNIT_REDACTION')")]
    #[Route(path: '/{unitId}/card-info', name: 'update_card_info', methods: ['PUT'])]
    #[ParamConverter('unit', options: ['mapping' => ['unitId' => 'uuid']])]
    public function update(Unit $unit, UpdateCardInfoModel $updateCardInfoModel): JsonResponse
    {
        $this->updateCardInfo->update($unit, $updateCardInfoModel);
        return $this->json('Card info has been updated');
    }
}