<?php

namespace App\Controller\Units\Data;

use App\Entity\Permissions\Permission;
use App\Entity\Purposes\ReadModel\PurposesQueryInterface;
use App\Entity\Units\UnitID;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;
use OpenApi\Annotations as OA;

/**
 * @OA\Tag(name="Units")
 */
#[Route(path: '/api/units', name: 'units_')]
class UnitGoalsDataController extends AbstractController
{
    public function __construct(
        private PurposesQueryInterface $purposesQuery
    ) {}

    /**
     * @OA\Get(summary="Goals list")
     */
    #[IsGranted(Permission::PUBLIC_ACCESS)]
    #[Route(path: '/{unitId}/goals', name: 'goals_list', methods: ['GET'])]
    public function list(string $unitId): JsonResponse
    {
        return $this->json(
            $this->purposesQuery->findGoalsListByUnitId(UnitID::fromString($unitId))
        );
    }
}