<?php

namespace App\Controller\Units\Data;

use App\Entity\Permissions\Permission;
use App\Entity\Units\ReadModel\UnitsQueryInterface;
use App\Entity\Units\UnitID;
use OpenApi\Annotations as OA;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @OA\Tag(name="Units")
 */
#[Route('/api/units', name: 'units_')]
class UnitChildrenDataController extends AbstractController
{
    public function __construct(
        private UnitsQueryInterface $unitsQuery,
    )
    {
    }

    /**
     * @OA\Get(summary="Show unit children by unitId")
     */
    #[IsGranted(Permission::UNIT_ADMINISTRATION)]
    #[Route(path: '/{unitId}/unit-children', name: 'show_unit_children_by_Id', methods: ['GET'])]
    public function showUnitChildren(string $unitId): JsonResponse
    {
        return $this->json(
            $this->unitsQuery->findAllPossibilityChildren(UnitID::fromString($unitId))
        );
    }

    /**
     * @OA\Get(summary="Show unit children without unitId")
     */
    #[IsGranted(Permission::UNIT_ADMINISTRATION)]
    #[Route(path: '/unit-children', name: 'show_unit_children', methods: ['GET'])]
    public function showUnitChildrenWithoutUnitId(): JsonResponse
    {
        return $this->json(
            $this->unitsQuery->findAllPossibilityChildren()
        );
    }
}