<?php

namespace App\Controller\Sliders\Data;

use App\Core\Paginator\ObjectValue\PaginationRequest;
use App\Entity\Permissions\Permission;
use App\Core\Paginator\ObjectValue\PaginationResults;
use App\Entity\Sliders\ReadModel\SliderQueryInterface;
use App\Entity\Units\ReadModel\UnitsQueryInterface;
use App\Entity\Units\UnitID;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use OpenApi\Annotations as OA;

/**
 * @OA\Tag(name="Sliders")
 */
class SliderDataController extends AbstractController
{
    public function __construct(
        private SliderQueryInterface $sliderQuery,
    ) {}

    /**
     * @OA\Get(summary="Slider data")
     */
    #[IsGranted(Permission::PUBLIC_ACCESS)]
    #[Route(path: 'api/slider', name: 'slider_data', methods: ['GET'])]
    public function sliderData(Request $request): JsonResponse
    {
        return $this->json(
            $this->sliderQuery->getSliderWithImages()
        );
    }

}