<?php

namespace App\Controller\Reports;

use App\Entity\Permissions\Permission;
use App\Entity\Reports\ReadModel\ReportsQueryInterface;
use App\ReportSystem\ExcelGenerator;
use App\ReportSystem\SubscriptionReportConfig;
use OpenApi\Annotations as OA;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\Routing\Annotation\Route;

/** @OA\Tag(name="Reports") */
#[Route('/api/reports', name: 'reports_')]
class SubscriptionsReportController extends AbstractController
{
    public function __construct(
        private ReportsQueryInterface $reportsQuery,
        private ExcelGenerator $excelGenerator
    )
    {
    }

    /**
     * @OA\Get(summary="Get finances report data, filename sent in headers Content-Dosposition, attachment attr")
     */
    #[IsGranted(Permission::UNIT_ADMINISTRATION)]
    #[Route(path: '/subscriptions', name: 'subscriptions', methods: ['GET'])]
    public function subscriptionsReport(): BinaryFileResponse
    {
        $data = $this->reportsQuery->getSubscriptionsReportData();

        $stream = $this->excelGenerator->generateReport(new SubscriptionReportConfig($data, $this->getParameter('file.report_dir')));

        $response = new BinaryFileResponse($stream);
        $response->setContentDisposition('attachment',$stream->getBasename());
        $response->headers->set('X-suggested-filename', $stream->getBasename());


        return $response;
    }
}