<?php

namespace App\Controller\Reports;

use App\Core\Paginator\ObjectValue\PaginationRequest;
use App\Core\Paginator\ObjectValue\PaginationResults;
use App\Entity\Permissions\Permission;
use App\Entity\Reports\ReadModel\ReportsQueryInterface;
use OpenApi\Annotations as OA;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

/** @OA\Tag(name="Reports") */
#[Route('/api/reports', name: 'reports_')]
class QuarterReportController extends AbstractController
{
    public function __construct(
        private ReportsQueryInterface $reportsQuery,
        private PaginationResults $paginationResults
    )
    {
    }

    /**
     * @OA\Get(summary="Get quarters report data")
     * @OA\Parameter(name="page", in="query", description="page number")
     * @OA\Parameter(name="perPage", in="query", description="item per page")
     */
    #[IsGranted(Permission::UNIT_ADMINISTRATION)]
    #[Route(path: '/quarters', name: 'quarters', methods: ['GET'])]
    public function ordersReport(Request $request): JsonResponse
    {
        $results = $this->reportsQuery->getQuartersReportData(PaginationRequest::build($request));
        return $this->json(
            $this->paginationResults->data($results)->totalRow()
        );
    }
}