<?php

namespace App\Controller\Reports\Create;

use App\Core\Exception\ApiException;
use App\Entity\Permissions\Permission;
use App\Models\Reports\RecipientReportModel;
use App\Models\Reports\ReportModel;
use App\Services\Reports\CreateQuarterReport;
use Nelmio\ApiDocBundle\Annotation\Model;
use OpenApi\Annotations as OA;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;

/** @OA\Tag(name="Reports") */
#[Route('/api/reports', name: 'reports_')]
class CreateQuarterReportController extends AbstractController
{
    public function __construct(
        private CreateQuarterReport $createQuarterReport
    )
    {
    }

    /**
     * @OA\Post(summary="Create quarter report")
     * @OA\RequestBody(
     *     @Model(type=ReportModel::class)
     * )
     */
    #[IsGranted(Permission::UNIT_ADMINISTRATION)]
    #[Route('', name: 'create', methods: ['POST'])]
    #[ParamConverter('reportModel', converter: "json_deserialize_param_converter")]
    public function create(ReportModel $reportModel): JsonResponse
    {
        $this->createQuarterReport->create($reportModel);

        return $this->json(['Quarter report has been created and send']);
    }

    /**
     * @OA\Post(summary="Preview quarter report, send on provided email")
     * @OA\RequestBody(
     *     @Model(type=RecipientReportModel::class)
     * )
     * @throws ApiException
     */
    #[IsGranted(Permission::UNIT_ADMINISTRATION)]
    #[Route('/preview', name: 'preview', methods: ['POST'])]
    #[ParamConverter('recipientReportModel', converter: "json_deserialize_param_converter")]
    public function preview(RecipientReportModel $recipientReportModel): JsonResponse
    {
        $this->createQuarterReport->preview($recipientReportModel);

        return $this->json(['Quarter report has been send']);
    }
}