<?php

namespace App\Controller\HearthAdoption;

use App\Entity\HearthAdoption\HearthAdoption;
use App\Entity\Permissions\Permission;
use App\Models\HearthAdoption\UpdateHearthAdoptionModel;
use App\Services\HearthAdoption\UpdateHearthAdoption;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;
use OpenApi\Annotations as OA;
use Nelmio\ApiDocBundle\Annotation\Model;

/**
 * @OA\Tag(name="Hearth adoption")
 */
#[Route(path: '/api/hearth-adoptions', name: 'hearth_adoptions_')]
class UpdateHearthAdoptionController extends AbstractController
{
    public function __construct(
        private UpdateHearthAdoption $updateHearthAdoption
    ) {}

    /**
     * @OA\Put(summary="Update hearth adoption")
     * @OA\RequestBody(
     *     @Model(type=UpdateHearthAdoptionModel::class)
     * )
     */
    #[Security("is_granted('ROLE_UNIT_ADMINISTRATION') or is_granted('ROLE_UNIT_REDACTION')")]
    #[Route(path: '/{hearthAdoptionId}', name: 'update', methods: ['PUT'])]
    #[ParamConverter('hearthAdoption', options: ['mapping' => ['hearthAdoptionId' => 'uuid']])]
    public function updateHearthAdoption(HearthAdoption $hearthAdoption, UpdateHearthAdoptionModel $updateHearthAdoptionModel): JsonResponse
    {
        $this->updateHearthAdoption->update($hearthAdoption, $updateHearthAdoptionModel);
        return $this->json('Hearth adoption has been updated');
    }
}