<?php
namespace App\Controller\BankStatements;

use OpenApi\Annotations as OA;
use App\Entity\Permissions\Permission;
use Nelmio\ApiDocBundle\Annotation\Model;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;



/**
 * 
 */
#[Route(path: '/api', name:'bank_statement_')]
class UploadStatementsController extends AbstractController
{
    public function __construct(

    )
    {
        
    }

    /**
     * @OA\Post(summary="Upload bank statement to app")
     * @OA\RequestBody(
     *     @OA\MediaType(
     *         mediaType="multipart/form-data",
     *         @OA\Schema(
     *             type="object",
     *             @OA\Property(
     *                 property="statements[]",
     *                 type="array",
     *                 @OA\Items(type="file")
     *             )
     *         )
     *     )
     * )
     */
    #[IsGranted(Permission::UNIT_ADMINISTRATION)]
    #[Route(path: '/bank-statement-upload', name: 'upload_bank_statement', methods: ['POST'])]
    public function upload(
        //BankStatementModel  $bankStatementModel
        ): JsonResponse
    {
        //$this->uploadPhotos->upload($sliderPhotosModel);
        return $this->json('Statements have been uploaded');
    }

}