<?php

namespace App\Command;

use App\Entity\Subscriptions\SubscriptionsInterface;
use App\Services\Orders\SubscriptionUnpaid;
use Psr\Log\LoggerInterface;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class SubscriptionsUnpaidCommand extends Command
{
    protected static $defaultName = 'subscription:unpaid';

    public function __construct(
        private LoggerInterface $paymentLogger,
        private SubscriptionsInterface $subscriptions,
        private SubscriptionUnpaid $subscriptionUnpaid
    )
    {
        parent::__construct();
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {

        $this->paymentLogger->info('Script ' . self::$defaultName . ' start');

        foreach ($this->subscriptions->findAllUnpaid() as $subscription) {
            $this->subscriptionUnpaid->unpaid($subscription);
        }

        $this->paymentLogger->info('Script ' . self::$defaultName . ' end');

        return 1;
    }
}