<?php

namespace App\Command;

use App\Entity\Subscriptions\SubscriptionsInterface;
use App\Services\Orders\SubscriptionExpired;
use Psr\Log\LoggerInterface;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class SubscriptionsExpiredCommand extends Command
{
    protected static $defaultName = 'subscription:expired';

    public function __construct(
        private LoggerInterface $paymentLogger,
        private SubscriptionsInterface $subscriptions,
        private SubscriptionExpired $subscriptionExpired
    )
    {
        parent::__construct();
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->paymentLogger->info('Script ' . self::$defaultName . ' start');

        foreach ($this->subscriptions->findAllExpired() as $subscription) {
            $this->subscriptionExpired->expired($subscription);
        }
        $this->paymentLogger->info('Script ' . self::$defaultName . ' end');

        return 1;
    }
}