<?php

namespace App\Adapter\Users\Email;

use App\Core\Notification\NotifierManagerInterface;
use App\Entity\Users\User;

class UserUserNotifications implements UserNotificationsInterface
{
    const ACTIVATION_SUBJECT = 'Witamy w gronie darczyńców Salvatti Edu';
    const ACTIVATION_TEMPLATE = 'email/activation.html.twig';

    const RESET_SUBJECT = 'Reset hasła';
    const RESET_TEMPLATE = 'email/reset_password.html.twig';

    public function __construct(
        private NotifierManagerInterface $notifier
    )
    {
    }

    public function sendActivationEmail(User $user): void
    {
        $context = [
            'token' => $user->getToken()
        ];

        $this->notifier->sendMail(self::ACTIVATION_SUBJECT, $context, self::ACTIVATION_TEMPLATE, $user);
    }

    public function sendResetPasswordEmail(User $user): void
    {
        $context = [
            'token' => $user->getToken()
        ];

        $this->notifier->sendMail(self::RESET_SUBJECT, $context, self::RESET_TEMPLATE, $user);
    }

}