<?php

namespace App\Adapter\Subscriptions\ReadModel;

use App\Entity\Subscriptions\ReadModel\SubscriptionDTO;
use App\Entity\Subscriptions\ReadModel\SubscriptionsQueryInterface;
use App\Entity\Subscriptions\SubscriptionID;
use Doctrine\DBAL\Connection;

class SubscriptionsQuery implements SubscriptionsQueryInterface
{
    public function __construct(
        private Connection $connection
    )
    {
    }

    public function getOneBySubscriptionID(SubscriptionID $subscriptionID): SubscriptionDTO
    {
        $qb = $this->connection->createQueryBuilder();

        $result = $qb
            ->select('s.uuid as subscriptionId')
            ->addSelect('u.title as unitTitle')
            ->addSelect('u.type as unitType')
            ->addSelect('u.uuid as unitId')
            ->addSelect('a.monthly_cost as unitMonthlyCost')
            ->addSelect('s.monthly_cost as subscriptionMonthlyCost')
            ->addSelect('s.children as subscriptionChildren')
            ->addSelect('s.date_end as dateEnd')
            ->from('subscription', 's')
            ->leftJoin('s', 'unit', 'u', 's.unit_id = u.uuid')
            ->leftJoin('u', 'hearth_adoption', 'a', 'u.adoption_id = a.uuid')
            ->where('s.uuid = :subscriptionID')
            ->setParameter('subscriptionID', $subscriptionID, 'uuid')
            ->execute()
            ->fetch();

        return  SubscriptionDTO::fromArray($result);
    }
}