<?php

namespace App\Adapter\Subscriptions\Email;

use App\Core\Exception\ApiException;
use App\Entity\Units\Helper\Type as UnitType;

class SubscriptionRemindNotificationTemplate
{
    private string $type;
    private static array $typesTemplates = [
        UnitType::INSTITUTION => [
            'subject' => 'Twoja subskrypcja dobiega końca',
            'template' => 'email/institution_remind.html.twig'
        ],

        UnitType::FAMILY => [
            'subject' => 'Twoja subskrypcja dobiega końca',
            'template' => 'email/family_remind.html.twig'
        ]
    ];

    public function __construct(
        UnitType $type
    )
    {
        $this->type = (string)$type;
    }

    /**
     * @return string
     * @throws ApiException
     */
    public function getTemplate(): string
    {
        if (isset(self::$typesTemplates[$this->type]['template'])) {
            return self::$typesTemplates[$this->type]['template'];
        }
        throw new ApiException('typeTemplate error');
    }

    public function getSubject(): string
    {
        if (isset(self::$typesTemplates[$this->type]['subject'])) {
            return self::$typesTemplates[$this->type]['subject'];
        }
        throw new ApiException('subject error');
    }
}