<?php

namespace App\Adapter\Roles;

use App\Entity\Roles\Role;
use App\Entity\Roles\RoleID;
use App\Entity\Roles\RolesInterface;
use Doctrine\ORM\EntityManagerInterface;

class Roles implements RolesInterface
{
    public function __construct(
        private EntityManagerInterface $entityManager
    ) {}

    public function findOneRoleByOriginalName(string $originalName): Role
    {
        return $this->entityManager
            ->getRepository(Role::class)
            ->findOneBy(['originalName' => $originalName]);
    }

    /**
     * @param RoleID $roleID
     * @return Role
     */
    public function findOneRoleById(RoleID $roleID): Role
    {
        return $this->entityManager
            ->getRepository(Role::class)
            ->findOneBy(['uuid' => $roleID]);
    }
}