<?php

namespace App\Adapter\Orders;

use App\Entity\Orders\Helper\OrderStatus;
use App\Entity\Orders\Order;
use App\Entity\Orders\OrderID;
use App\Entity\Orders\OrdersInterface;
use Doctrine\ORM\EntityManagerInterface;

class Orders implements OrdersInterface
{
    /**
     * @param EntityManagerInterface $entityManager
     */
    public function __construct(
        private EntityManagerInterface $entityManager
    )
    {
    }

    public function add(Order $order): void
    {
        $this->entityManager->persist($order);
    }

    public function findAll()
    {
        return $this->entityManager->getRepository(Order::class)->findAll();
    }

    public function findWithoutTransactionNumber(?OrderID $orderID, ?int $limit): array
    {
        $qb = $this->entityManager->createQueryBuilder();

        $qb
            ->select('sO')
            ->from(Order::class, 'sO')
            ->where('sO.transactionNumber IS NULL OR sO.transactionNumber = :empty')
            ->andWhere('sO.status =:status')
            ->setParameter('status', OrderStatus::VERIFIED)
            ->setParameter('empty', '');

        if ($orderID) {
            $qb
                ->andWhere('sO.uuid =:orderID')
                ->setParameter('orderID', $orderID, 'uuid');
        }

        if ($limit) {
            $qb
                ->setMaxResults($limit);
        }

        return $qb
            ->getQuery()
            ->execute();
    }
}