<?php

namespace App\Adapter\HearthAdoption\ReadModel;

use App\Entity\HearthAdoption\HearthAdoptionID;
use App\Entity\HearthAdoption\ReadModel\HearthAdoptionQueryInterface;
use App\Entity\HearthAdoption\ReadModel\HearthAdoptionDTO;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Exception;

class HearthAdoptionQuery implements HearthAdoptionQueryInterface
{
    public function __construct(
        private Connection $connection
    ) {}

    /**
     * @throws Exception
     * @throws \ReflectionException
     */
    public function findOneHearthAdoptionById(HearthAdoptionID $hearthAdoptionID): ?HearthAdoptionDTO
    {
        $qb = $this->connection->createQueryBuilder();

        $result = $qb
            ->select('a.children')
            ->addSelect('a.monthly_cost as monthlyCost')
            ->addSelect('c.content')
            ->from('hearth_adoption', 'a')
            ->leftJoin('a', 'content', 'c', 'a.content_id = c.uuid')
            ->where('a.uuid = :hearthAdoptionId')
            ->setParameter('hearthAdoptionId', $hearthAdoptionID, 'uuid')
            ->execute()
            ->fetch();

        return $result ? HearthAdoptionDTO::fromArray($result) : null;
    }
}