<?php

namespace App\Adapter\Agreement\ReadModel;

use App\Entity\Agreement\ReadModel\AgreementDTO;
use App\Entity\Agreement\ReadModel\AgreementsQueryInterface;
use App\Entity\Users\UserID;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Exception;
use Doctrine\DBAL\Driver\Exception as DriverException;

class AgreementsQuery implements AgreementsQueryInterface
{
    public function __construct(
        private Connection $connection
    ) {}

    /**
     * @throws Exception
     * @throws DriverException
     * @throws \ReflectionException
     */
    public function findAllUserAgreements(UserID $userID): array
    {
        $qb = $this->connection->createQueryBuilder();

        $results = $qb
            ->select('a.uuid AS agreementId')
            ->addSelect('a.name AS agreementName')
            ->from('agreement', 'a')
            ->addSelect('uA.user_id AS userId')
            ->leftJoin('a', 'user_agreement', 'uA', 'a.uuid = uA.agreement_id AND (uA.user_id = :userId OR uA.user_id IS NULL)')
            ->setParameter('userId', $userID, 'uuid')
            ->orderBy('a.name', 'ASC')
            ->addOrderBy('a.is_required', 'DESC')
            ->execute()
            ->fetchAllAssociative();


        return array_map(fn($result) => AgreementDTO::FromArray($result), $results);
    }
}