<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20211022094711 extends AbstractMigration
{
    public function getDescription(): string
    {
        return '';
    }

    public function up(Schema $schema): void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->addSql('CREATE TABLE agreement (uuid BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', name LONGTEXT NOT NULL, is_required TINYINT(1) DEFAULT \'0\' NOT NULL, created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', PRIMARY KEY(uuid)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE content (uuid BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', content LONGTEXT NOT NULL, PRIMARY KEY(uuid)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE hearth_adoption (uuid BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', content_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', children INT NOT NULL, monthly_cost INT NOT NULL, modified_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', UNIQUE INDEX UNIQ_E0D2F5E584A0A3ED (content_id), PRIMARY KEY(uuid)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE image (uuid BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', unit_id BINARY(16) DEFAULT NULL COMMENT \'(DC2Type:uuid)\', image VARCHAR(255) NOT NULL, title VARCHAR(255) DEFAULT NULL, created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', INDEX IDX_C53D045FF8BD700D (unit_id), PRIMARY KEY(uuid)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE login_user_history (uuid BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', user_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', ip VARCHAR(30) NOT NULL, created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', INDEX IDX_B464AD71A76ED395 (user_id), PRIMARY KEY(uuid)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE payment (uuid BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', order_id BINARY(16) DEFAULT NULL COMMENT \'(DC2Type:uuid)\', amount INT NOT NULL, created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', INDEX IDX_6D28840D8D9F6D38 (order_id), PRIMARY KEY(uuid)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE permission (uuid BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', name VARCHAR(255) NOT NULL, authorization VARCHAR(255) NOT NULL, UNIQUE INDEX UNIQ_E04992AA5E237E06 (name), UNIQUE INDEX UNIQ_E04992AA7A6D8BEF (authorization), PRIMARY KEY(uuid)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE post (uuid BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', unit_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', photo_id BINARY(16) DEFAULT NULL COMMENT \'(DC2Type:uuid)\', content_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', title VARCHAR(100) NOT NULL, description VARCHAR(200) NOT NULL, created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', INDEX IDX_5A8A6C8DF8BD700D (unit_id), UNIQUE INDEX UNIQ_5A8A6C8D7E9E4C8C (photo_id), UNIQUE INDEX UNIQ_5A8A6C8D84A0A3ED (content_id), PRIMARY KEY(uuid)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE purpose (uuid BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', content_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', title VARCHAR(255) NOT NULL, created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', money INT DEFAULT 0 NOT NULL, modified_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', UNIQUE INDEX UNIQ_B887B3EB84A0A3ED (content_id), PRIMARY KEY(uuid)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE role (uuid BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', name VARCHAR(255) NOT NULL, original_name VARCHAR(255) DEFAULT NULL, UNIQUE INDEX UNIQ_57698A6A5E237E06 (name), UNIQUE INDEX UNIQ_57698A6A54561530 (original_name), PRIMARY KEY(uuid)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE role_permission (role_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', permission_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', INDEX IDX_6F7DF886D60322AC (role_id), INDEX IDX_6F7DF886FED90CCA (permission_id), PRIMARY KEY(role_id, permission_id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE subscription (uuid BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', user_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', unit_id BINARY(16) DEFAULT NULL COMMENT \'(DC2Type:uuid)\', children INT NOT NULL, monthly_cost INT NOT NULL, created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', date_start DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', date_end DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', kind_of_subscription VARCHAR(1) NOT NULL, is_active TINYINT(1) DEFAULT \'0\' NOT NULL, method_ref_id VARCHAR(255) DEFAULT NULL, cyclic_token VARCHAR(255) DEFAULT NULL, INDEX IDX_A3C664D3A76ED395 (user_id), INDEX IDX_A3C664D3F8BD700D (unit_id), PRIMARY KEY(uuid)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE sysOrder (uuid BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', user_id BINARY(16) DEFAULT NULL COMMENT \'(DC2Type:uuid)\', unit_id BINARY(16) DEFAULT NULL COMMENT \'(DC2Type:uuid)\', subscription_id BINARY(16) DEFAULT NULL COMMENT \'(DC2Type:uuid)\', email VARCHAR(255) NOT NULL, status VARCHAR(255) NOT NULL, token VARCHAR(255) NOT NULL, created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', verified_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', external_id INT DEFAULT NULL, amount INT NOT NULL, action VARCHAR(1) NOT NULL, url_return VARCHAR(255) NOT NULL, url_webhook VARCHAR(255) NOT NULL, INDEX IDX_4171E80CA76ED395 (user_id), INDEX IDX_4171E80CF8BD700D (unit_id), INDEX IDX_4171E80C9A1887DC (subscription_id), PRIMARY KEY(uuid)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE unit (uuid BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', photo_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', banner_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', card_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', purpose_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', adoption_id BINARY(16) DEFAULT NULL COMMENT \'(DC2Type:uuid)\', title VARCHAR(100) NOT NULL, description VARCHAR(255) NOT NULL, type VARCHAR(1) NOT NULL, is_active TINYINT(1) DEFAULT \'0\' NOT NULL, UNIQUE INDEX UNIQ_DCBB0C537E9E4C8C (photo_id), UNIQUE INDEX UNIQ_DCBB0C53684EC833 (banner_id), UNIQUE INDEX UNIQ_DCBB0C534ACC9A20 (card_id), UNIQUE INDEX UNIQ_DCBB0C537FC21131 (purpose_id), UNIQUE INDEX UNIQ_DCBB0C53631C55DF (adoption_id), PRIMARY KEY(uuid)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE user (uuid BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', role_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', name VARCHAR(50) NOT NULL, surname VARCHAR(50) NOT NULL, email VARCHAR(180) NOT NULL, password VARCHAR(255) NOT NULL, is_active TINYINT(1) DEFAULT \'0\' NOT NULL, is_blocked TINYINT(1) DEFAULT \'0\' NOT NULL, token VARCHAR(255) DEFAULT NULL, UNIQUE INDEX UNIQ_8D93D649E7927C74 (email), UNIQUE INDEX UNIQ_8D93D6495F37A13B (token), INDEX IDX_8D93D649D60322AC (role_id), PRIMARY KEY(uuid)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE user_agreement (user_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', agreement_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', INDEX IDX_2E85D7C0A76ED395 (user_id), INDEX IDX_2E85D7C024890B2B (agreement_id), PRIMARY KEY(user_id, agreement_id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE user_agreement_history (uuid BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', agreement_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', user_id BINARY(16) NOT NULL COMMENT \'(DC2Type:uuid)\', prev_status TINYINT(1) NOT NULL, ip VARCHAR(30) NOT NULL, created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', INDEX IDX_77BCFFC424890B2B (agreement_id), INDEX IDX_77BCFFC4A76ED395 (user_id), PRIMARY KEY(uuid)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('ALTER TABLE hearth_adoption ADD CONSTRAINT FK_E0D2F5E584A0A3ED FOREIGN KEY (content_id) REFERENCES content (uuid)');
        $this->addSql('ALTER TABLE image ADD CONSTRAINT FK_C53D045FF8BD700D FOREIGN KEY (unit_id) REFERENCES unit (uuid)');
        $this->addSql('ALTER TABLE login_user_history ADD CONSTRAINT FK_B464AD71A76ED395 FOREIGN KEY (user_id) REFERENCES user (uuid)');
        $this->addSql('ALTER TABLE payment ADD CONSTRAINT FK_6D28840D8D9F6D38 FOREIGN KEY (order_id) REFERENCES sysOrder (uuid)');
        $this->addSql('ALTER TABLE post ADD CONSTRAINT FK_5A8A6C8DF8BD700D FOREIGN KEY (unit_id) REFERENCES unit (uuid)');
        $this->addSql('ALTER TABLE post ADD CONSTRAINT FK_5A8A6C8D7E9E4C8C FOREIGN KEY (photo_id) REFERENCES image (uuid)');
        $this->addSql('ALTER TABLE post ADD CONSTRAINT FK_5A8A6C8D84A0A3ED FOREIGN KEY (content_id) REFERENCES content (uuid)');
        $this->addSql('ALTER TABLE purpose ADD CONSTRAINT FK_B887B3EB84A0A3ED FOREIGN KEY (content_id) REFERENCES content (uuid)');
        $this->addSql('ALTER TABLE role_permission ADD CONSTRAINT FK_6F7DF886D60322AC FOREIGN KEY (role_id) REFERENCES role (uuid)');
        $this->addSql('ALTER TABLE role_permission ADD CONSTRAINT FK_6F7DF886FED90CCA FOREIGN KEY (permission_id) REFERENCES permission (uuid)');
        $this->addSql('ALTER TABLE subscription ADD CONSTRAINT FK_A3C664D3A76ED395 FOREIGN KEY (user_id) REFERENCES user (uuid)');
        $this->addSql('ALTER TABLE subscription ADD CONSTRAINT FK_A3C664D3F8BD700D FOREIGN KEY (unit_id) REFERENCES unit (uuid)');
        $this->addSql('ALTER TABLE sysOrder ADD CONSTRAINT FK_4171E80CA76ED395 FOREIGN KEY (user_id) REFERENCES user (uuid)');
        $this->addSql('ALTER TABLE sysOrder ADD CONSTRAINT FK_4171E80CF8BD700D FOREIGN KEY (unit_id) REFERENCES unit (uuid)');
        $this->addSql('ALTER TABLE sysOrder ADD CONSTRAINT FK_4171E80C9A1887DC FOREIGN KEY (subscription_id) REFERENCES subscription (uuid)');
        $this->addSql('ALTER TABLE unit ADD CONSTRAINT FK_DCBB0C537E9E4C8C FOREIGN KEY (photo_id) REFERENCES image (uuid)');
        $this->addSql('ALTER TABLE unit ADD CONSTRAINT FK_DCBB0C53684EC833 FOREIGN KEY (banner_id) REFERENCES image (uuid)');
        $this->addSql('ALTER TABLE unit ADD CONSTRAINT FK_DCBB0C534ACC9A20 FOREIGN KEY (card_id) REFERENCES content (uuid)');
        $this->addSql('ALTER TABLE unit ADD CONSTRAINT FK_DCBB0C537FC21131 FOREIGN KEY (purpose_id) REFERENCES purpose (uuid)');
        $this->addSql('ALTER TABLE unit ADD CONSTRAINT FK_DCBB0C53631C55DF FOREIGN KEY (adoption_id) REFERENCES hearth_adoption (uuid)');
        $this->addSql('ALTER TABLE user ADD CONSTRAINT FK_8D93D649D60322AC FOREIGN KEY (role_id) REFERENCES role (uuid)');
        $this->addSql('ALTER TABLE user_agreement ADD CONSTRAINT FK_2E85D7C0A76ED395 FOREIGN KEY (user_id) REFERENCES user (uuid)');
        $this->addSql('ALTER TABLE user_agreement ADD CONSTRAINT FK_2E85D7C024890B2B FOREIGN KEY (agreement_id) REFERENCES agreement (uuid)');
        $this->addSql('ALTER TABLE user_agreement_history ADD CONSTRAINT FK_77BCFFC424890B2B FOREIGN KEY (agreement_id) REFERENCES agreement (uuid)');
        $this->addSql('ALTER TABLE user_agreement_history ADD CONSTRAINT FK_77BCFFC4A76ED395 FOREIGN KEY (user_id) REFERENCES user (uuid)');
    }

    public function down(Schema $schema): void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->addSql('ALTER TABLE user_agreement DROP FOREIGN KEY FK_2E85D7C024890B2B');
        $this->addSql('ALTER TABLE user_agreement_history DROP FOREIGN KEY FK_77BCFFC424890B2B');
        $this->addSql('ALTER TABLE hearth_adoption DROP FOREIGN KEY FK_E0D2F5E584A0A3ED');
        $this->addSql('ALTER TABLE post DROP FOREIGN KEY FK_5A8A6C8D84A0A3ED');
        $this->addSql('ALTER TABLE purpose DROP FOREIGN KEY FK_B887B3EB84A0A3ED');
        $this->addSql('ALTER TABLE unit DROP FOREIGN KEY FK_DCBB0C534ACC9A20');
        $this->addSql('ALTER TABLE unit DROP FOREIGN KEY FK_DCBB0C53631C55DF');
        $this->addSql('ALTER TABLE post DROP FOREIGN KEY FK_5A8A6C8D7E9E4C8C');
        $this->addSql('ALTER TABLE unit DROP FOREIGN KEY FK_DCBB0C537E9E4C8C');
        $this->addSql('ALTER TABLE unit DROP FOREIGN KEY FK_DCBB0C53684EC833');
        $this->addSql('ALTER TABLE role_permission DROP FOREIGN KEY FK_6F7DF886FED90CCA');
        $this->addSql('ALTER TABLE unit DROP FOREIGN KEY FK_DCBB0C537FC21131');
        $this->addSql('ALTER TABLE role_permission DROP FOREIGN KEY FK_6F7DF886D60322AC');
        $this->addSql('ALTER TABLE user DROP FOREIGN KEY FK_8D93D649D60322AC');
        $this->addSql('ALTER TABLE sysOrder DROP FOREIGN KEY FK_4171E80C9A1887DC');
        $this->addSql('ALTER TABLE payment DROP FOREIGN KEY FK_6D28840D8D9F6D38');
        $this->addSql('ALTER TABLE image DROP FOREIGN KEY FK_C53D045FF8BD700D');
        $this->addSql('ALTER TABLE post DROP FOREIGN KEY FK_5A8A6C8DF8BD700D');
        $this->addSql('ALTER TABLE subscription DROP FOREIGN KEY FK_A3C664D3F8BD700D');
        $this->addSql('ALTER TABLE sysOrder DROP FOREIGN KEY FK_4171E80CF8BD700D');
        $this->addSql('ALTER TABLE login_user_history DROP FOREIGN KEY FK_B464AD71A76ED395');
        $this->addSql('ALTER TABLE subscription DROP FOREIGN KEY FK_A3C664D3A76ED395');
        $this->addSql('ALTER TABLE sysOrder DROP FOREIGN KEY FK_4171E80CA76ED395');
        $this->addSql('ALTER TABLE user_agreement DROP FOREIGN KEY FK_2E85D7C0A76ED395');
        $this->addSql('ALTER TABLE user_agreement_history DROP FOREIGN KEY FK_77BCFFC4A76ED395');
        $this->addSql('DROP TABLE agreement');
        $this->addSql('DROP TABLE content');
        $this->addSql('DROP TABLE hearth_adoption');
        $this->addSql('DROP TABLE image');
        $this->addSql('DROP TABLE login_user_history');
        $this->addSql('DROP TABLE payment');
        $this->addSql('DROP TABLE permission');
        $this->addSql('DROP TABLE post');
        $this->addSql('DROP TABLE purpose');
        $this->addSql('DROP TABLE role');
        $this->addSql('DROP TABLE role_permission');
        $this->addSql('DROP TABLE subscription');
        $this->addSql('DROP TABLE sysOrder');
        $this->addSql('DROP TABLE unit');
        $this->addSql('DROP TABLE user');
        $this->addSql('DROP TABLE user_agreement');
        $this->addSql('DROP TABLE user_agreement_history');
    }

    public function isTransactional(): bool
    {
        return false;
    }
}
